/*  Source Code for PSRAM Low Level Driver */


#ifndef __INC_H_SLL_PSRAM_DRVRH
#define __INC_H_SLL_PSRAM_DRVRH


#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

#include "sll_ca_xspi_mc_t004_reg.h"

 
/*Define Version */
#define SLL_PSRAM_DRVR_VERSION  "22.1.1"   //  Year.Quarter.Minor
 
/**********************  
   Xccela RAM Defines  
***********************/

/*Xccela Register Commands */
#define XCELLA_PSRAM_REG_READ_CMD  0x4040
#define XCELLA_PSRAM_REG_WRITE_CMD 0xC0C0


/*   API  */
#define XCELLA_PSRAM_GET_REG(base,offset)      sll_xspi_mc_reg_read(base, (uint32_t) XCELLA_PSRAM_REG_READ_CMD,  offset, SLL_XSPI_MC_RAM_CS1_RD);
#define XCELLA_PSRAM_SET_REG(base,offset,data) sll_xspi_mc_reg_write(base,(uint32_t) XCELLA_PSRAM_REG_WRITE_CMD, offset, SLL_XSPI_MC_RAM_CS1_WR, data << 8);


/**********************  
   OctaRAM Defines  
***********************/

/*OctaRAM Register Commands */
#define OCTARAM_PSRAM_REG_READ_CMD  0xC000
#define OCTARAM_PSRAM_REG_WRITE_CMD 0x6000

#define OCTARAM_ID0_ADDR           0x00000000
#define OCTARAM_CR0_ADDR           0x00040000


/*   API  */
#define OCTARAM_PSRAM_GET_REG(base,offset)      sll_xspi_mc_reg_read(base, (uint32_t) OCTARAM_PSRAM_REG_READ_CMD,  offset, SLL_XSPI_MC_RAM_CS1_RD);
#define OCTARAM_PSRAM_SET_REG(base,offset,data) sll_xspi_mc_reg_write(base,(uint32_t) OCTARAM_PSRAM_REG_WRITE_CMD, offset, SLL_XSPI_MC_RAM_CS1_WR, data);

/**********************  
   Hyperram Defines  
***********************/

/*Hyperram Register Commands */
#define HYPERRAM_DIE0_REG_READ_CMD  0xC000
#define HYPERRAM_DIE0_REG_WRITE_CMD 0x6000

#define HYPERRAM_DIE1_REG_READ_CMD  0xC008
#define HYPERRAM_DIE1_REG_WRITE_CMD 0x6008

#define HYPERRAM_ID0_ADDR           0x00000000
#define HYPERRAM_ID1_ADDR           0x00000001

#define HYPERRAM_CFG0_ADDR          0x01000000
#define HYPERRAM_CFG1_ADDR          0x01000001


/*   API  */
#define HYPERRAM_PSRAM_GET_REG(base,offset)           sll_xspi_mc_reg_read(base, (uint32_t) HYPERRAM_DIE0_REG_READ_CMD,  offset, SLL_XSPI_MC_RAM_CS1_RD);
#define HYPERRAM_PSRAM_SET_REG(base,offset,data)      sll_xspi_mc_reg_write(base,(uint32_t) HYPERRAM_DIE0_REG_WRITE_CMD, offset, SLL_XSPI_MC_RAM_CS1_WR, data);

#define HYPERRAM_PSRAM_DIE1_GET_REG(base,offset)      sll_xspi_mc_reg_read(base, (uint32_t) HYPERRAM_DIE1_REG_READ_CMD,  offset, SLL_XSPI_MC_RAM_CS1_RD);
#define HYPERRAM_PSRAM_DIE1_SET_REG(base,offset,data) sll_xspi_mc_reg_write(base,(uint32_t) HYPERRAM_DIE1_REG_WRITE_CMD, offset, SLL_XSPI_MC_RAM_CS1_WR, data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __INC_H_SLL_PSRAM_DRVRH  */


